//
//  ComboBox.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 27/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
class ComboBox: UIView, UIPickerViewDelegate, UIPickerViewDataSource, UITextFieldDelegate {
    var textField: UITextField!
    var pickerView: UIPickerView!

    var options = [AnyObject]()
    var keys = [AnyObject]()
    var text = ""
    var value = ""

    override func setDefaultValue(index: Int) {
        if index <= options.count && index >= 0 {
            textField.text = options[index]
            self.text = textField.text
            self.value = keys[index]
        }
    }


    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.initialize()
    
    }

    override func initialize() {
        textField = UITextField(frame: CGRectMake(0, 0, self.frame.size.width, self.frame.size.height))
        textField.borderStyle = .RoundedRect
        textField.addTarget(self, action: (self.showPicker), forControlEvents: .TouchDown)
        textField.delegate = self
        textField.text = "select options"
        self.tag = 111
        self.addSubview(textField)
        self.value = nil
        self.text = "Select Option"
    }
    //-- UIPickerViewDelegate, UIPickerViewDataSource

    override func numberOfComponentsInPickerView(pickerView: UIPickerView) -> Int {
        return 1
    }

    func pickerView(pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int) {
        textField.text = options[row]
        self.text = textField.text
        self.value = keys[row]
    }

    override func pickerView(pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        return options.count
    }

    func pickerView(pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String {
        return options[row]
    }

    func doneClicked(sender: AnyObject) {
        var index = Int(pickerView.selectedRowInComponent(0))
        textField.text = options[index]
        self.text = textField.text
        self.value = keys[index]
        textField.resignFirstResponder()
        //hides the pickerView
    }

    @IBAction func showPicker(sender: AnyObject) {
        pickerView == nil ? pickerView[UIPickerView] : ""
        pickerView.showsSelectionIndicator = true
        pickerView.dataSource = self
        pickerView.delegate = self
        var toolbar = UIToolbar()
        toolbar.barStyle = .BlackTranslucent
        toolbar.sizeToFit()
        var flexibleSpaceLeft = UIBarButtonItem(barButtonSystemItem: .FlexibleSpace, target: nil, action: nil)
        var doneButton = UIBarButtonItem(title: "Done", style: .Done, target: self, action: (self.doneClicked))
        toolbar.items = [flexibleSpaceLeft, doneButton]
        //custom input view
        textField.inputView = pickerView
        textField.inputAccessoryView! = toolbar
    }

    func textFieldShouldBeginEditing(aTextField: UITextField) -> Bool {
        self.showPicker(aTextField)
        return true
    }

    func textField(textField: UITextField, shouldChangeCharactersInRange range: NSRange, replacementString string: String) -> Bool {
        return false
    }
}